/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.specials;

import com.probejs.ProbeCommands;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.docs.formatter.formatter.FormatterNamespace;
import com.probejs.docs.formatter.formatter.IFormatter;
import com.probejs.util.RLHelper;
import com.probejs.util.Util;
import dev.latvian.mods.kubejs.server.tag.TagEventJS;
import dev.latvian.mods.kubejs.server.tag.TagWrapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

public class TagEventCompiler {
    public static void compileTagEvents() throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("tag_events.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        FormatterNamespace namespace = new FormatterNamespace("TagEvent", ProbeCommands.COMMAND_LEVEL.method_30349().method_40311().map(class_5455.class_6892::comp_350).map(r -> new FormatterTagEvent((class_5321<class_2378<?>>)r)).collect(Collectors.toList()));
        writer.write(String.join((CharSequence)"\n", namespace.format(0, 4)));
        writer.close();
    }

    public static List<String> getTagEventOverrides() {
        ArrayList<String> lines = new ArrayList<String>();
        ProbeCommands.COMMAND_LEVEL.method_30349().method_40311().forEach(entry -> {
            if (entry.comp_351().method_40273().findAny().isEmpty()) {
                return;
            }
            class_5321 registry = entry.comp_350();
            if (registry.method_29177().method_12836().equals("minecraft")) {
                lines.add("tags(type: %s, handler: (event: TagEvent.%s) => void): void".formatted(ProbeJS.GSON.toJson((Object)registry.method_29177().method_12832()), RLHelper.finalComponentToTitle(registry.method_29177().method_12832())));
            }
            lines.add("tags(type: %s, handler: (event: TagEvent.%s) => void): void".formatted(ProbeJS.GSON.toJson((Object)registry.method_29177().toString()), RLHelper.finalComponentToTitle(registry.method_29177().method_12832())));
        });
        return lines;
    }

    public static class FormatterTagEvent
    implements IFormatter {
        private final class_5321<class_2378<?>> registry;

        public FormatterTagEvent(class_5321<class_2378<?>> registry) {
            this.registry = registry;
        }

        @Override
        public List<String> format(Integer indent, Integer stepIndent) {
            ArrayList<String> formatted = new ArrayList<String>();
            String capitalized = RLHelper.finalComponentToTitle(this.registry.method_29177().method_12832());
            String specialType = "Special.%s".formatted(capitalized);
            String tagType = specialType + "Tag";
            String wrapperType = Util.formatMaybeParameterized(TagWrapper.class);
            formatted.add("%sclass %s extends %s {".formatted(" ".repeat(indent), capitalized, Util.formatMaybeParameterized(TagEventJS.class)));
            formatted.add("%sget(id: %s): %s".formatted(" ".repeat(indent), tagType, wrapperType));
            formatted.add("%sadd(tag: %s, ...id: %s[]): %s".formatted(" ".repeat(indent), tagType, specialType, wrapperType));
            formatted.add("%sremove(tag: %s, ...id: %s[]): %s".formatted(" ".repeat(indent), tagType, specialType, wrapperType));
            formatted.add("%sremoveAll(tag: %s): %s".formatted(" ".repeat(indent), tagType, wrapperType));
            formatted.add("%sremoveAllTagsFrom(...id: %s[]): %s".formatted(" ".repeat(indent), specialType, wrapperType));
            formatted.add(" ".repeat(indent) + "}");
            return formatted;
        }
    }
}

